CREATE TABLE `sys_org_bu_tree`
(
    `id`                  bigint NOT NULL COMMENT '记录唯一ID',
    `bu_tree_type`        varchar(32)  DEFAULT NULL COMMENT '组织树类型',
    `bu_tree_type2`       varchar(32)  DEFAULT NULL COMMENT '组织树类型2',
    `bu_tree_type3`       varchar(32)  DEFAULT NULL COMMENT '组织树类型3',
    `bu_tree_status`      varchar(32)  DEFAULT NULL COMMENT '组织树状态',
    `bu_tree_code`        varchar(32)  DEFAULT NULL COMMENT '组织树编号',
    `bu_tree_name`        varchar(64)  DEFAULT NULL COMMENT '组织树名称',
    `bu_tree_version`     varchar(32)  DEFAULT NULL COMMENT '组织树版本',
    `now_version`         varchar(32)  DEFAULT NULL COMMENT '组织树当前版本',
    `cat`                 varchar(32)  DEFAULT NULL COMMENT '类别码',
    `cat2`                varchar(32)  DEFAULT NULL COMMENT '类别码2',
    `cat3`                varchar(32)  DEFAULT NULL COMMENT '类别码3',
    `cat4`                varchar(32)  DEFAULT NULL COMMENT '类别码4',
    `cat5`                varchar(32)  DEFAULT NULL COMMENT '类别码5',
    `cat6`                varchar(32)  DEFAULT NULL COMMENT '类别码6',
    `cat7`                varchar(32)  DEFAULT NULL COMMENT '类别码',
    `cat8`                varchar(32)  DEFAULT NULL COMMENT '类别码8',
    `cat9`                varchar(32)  DEFAULT NULL COMMENT '类别码9',
    `cat10`               varchar(32)  DEFAULT NULL COMMENT '类别码10',
    `release_time`        datetime(6)  DEFAULT NULL COMMENT '发布时间',
    `is_now_version`      bit(1)       DEFAULT NULL COMMENT '是否当前版本',
    `disable_time`        datetime(6)  DEFAULT NULL COMMENT '停用时间',
    `release_user`        varchar(255) DEFAULT NULL COMMENT '发布人',
    `version_instruction` varchar(255) DEFAULT NULL COMMENT '版本说明',
    `tenant_id`           bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`       bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`       bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`              varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`      bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`             varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`         datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`      bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`             varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`         datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`         int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`  int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`           bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`         bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`           bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='组织树';
CREATE TABLE `sys_org_bu_tree_d`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `bu_tree_id`         bigint       DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint       DEFAULT NULL COMMENT '组织ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT '组织编号',
    `data_source`        varchar(40)  DEFAULT NULL COMMENT '类别码20',
    `sync_status`        tinyint(1)   DEFAULT '0' COMMENT '同步的数据是否需要覆盖',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    `pid`                bigint NOT NULL COMMENT '上级ID',
    `sort_no`            int          DEFAULT NULL COMMENT '排序号',
    `level`              int          DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255) DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    PRIMARY KEY (`id`),
    KEY `idx_bu_tree_pid` (`pid`),
    KEY `idx_bu_tree_code_path` (`code_path`)
) COMMENT ='组织树明细';
CREATE TABLE `sys_org_bu_tree_version`
(
    `id`                 bigint NOT NULL COMMENT '记录唯一ID',
    `tenant_id`          bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`      bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`      bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version` int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`        bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`          bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
) COMMENT ='组织树版本';

ALTER TABLE `sys_org`
    ADD COLUMN `extension_info` json NULL COMMENT '扩展字段' AFTER `english_name`;